#include <bits/stdc++.h>

using namespace std;

int main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);

    int64_t n;
    cin >> n;

    vector<int64_t> pozicije(n);
    vector<int64_t> visine(n);
    for (int64_t i = 0; i < n; i++) cin >> pozicije[i];
    for (int64_t i = 0; i < n; i++) cin >> visine[i];

    // SORITRANJE AAAAAAAAAAAAAAAAAAAAAAAA
    vector<pair<int64_t,int64_t>> a(n);
    for (int64_t i = 0; i < n; i++) {
        a[i] = {pozicije[i], visine[i]};
    }
    sort(a.begin(), a.end());
    for (int64_t i = 0; i < n; i++) {
        pozicije[i] = a[i].first;
        visine[i]   = a[i].second;
    }
    a.clear();

    map<int64_t,int64_t> jarboli;

    // Going from left to right -> -> ->
    map<int64_t,int64_t> najbliza_desno;
    for (int64_t i = 0; i < n - 1; i++)
    {
        // Step 1 - dodaj jarbol u set

        int64_t pozicija = pozicije[i];
        int64_t visina = visine[i];
        jarboli[visina] = pozicija;
//        cout << "Ubacujem jarbol " << pozicija << endl;

        // Step 2 - odrediti sve tacke

        int64_t dx = pozicije[i + 1] - pozicija;
        int64_t dy = visine[i + 1] - visina;

        int64_t duzina_prvog = (dx - abs(dy)) / 2;
        int64_t duzina_drugog = dx - duzina_prvog;

        // Fix bug...
        if (dy < 0) swap(duzina_prvog, duzina_drugog);

        int64_t tacka_preloma_x = pozicija + duzina_prvog;
        int64_t tacka_preloma_y = visina - duzina_prvog;

//        cout << "  Tacka preloma izmedju jarbola " << pozicija << " " << pozicije[i + 1];
//        cout << " je na poziciji " << tacka_preloma_x << " i visini " << tacka_preloma_y;
//        cout << endl;
        // Tacka preloma izmedju jarbola 1 6 je na poziciji 3 i visini 2
        // Tacka preloma izmedju jarbola 6 10 je na poziciji 7 i visini 4

        // Step 3 - koji jarboli se poklapaju sa nekom od dve duzi
        //          (y izmedju tacke preloma i najviseg od dva jarbola)

        int64_t min_y = tacka_preloma_y;
        int64_t max_y = max(visina, visine[i + 1]);

        // Trazim jarbole cija je visina >= tacka_preloma_y
        auto poklapanje = jarboli.lower_bound(tacka_preloma_y);

        set<int64_t> izbaceni_jarboli;

        while (poklapanje != jarboli.end() && poklapanje->first <= max_y) {
//            cout << "  Proveravam jarbol " << poklapanje->second << " visine " << poklapanje->first << endl;
            int64_t najbliza_x = pozicija + abs(visina - poklapanje->first);
            if (poklapanje->first <= visina && poklapanje->second != najbliza_x) {
                // Opadajuca duz
                najbliza_desno[poklapanje->second] = najbliza_x;
//                cout << "    1) Jarbol " << poklapanje->second << " ima tacku desno na " << najbliza_x << endl;
                izbaceni_jarboli.insert(poklapanje->first);
            }
            else if(visine[i+1] >= visina) {
                // Rastuca duz
                najbliza_x =  pozicije[i+1] - abs(visine[i+1] - poklapanje->first);
                najbliza_desno[poklapanje->second] = najbliza_x;
//                cout << "    2) Jarbol " << poklapanje->second << " ima tacku desno na " << najbliza_x << endl;
                izbaceni_jarboli.insert(poklapanje->first);
            }
            poklapanje++;
        }

        for (auto j : izbaceni_jarboli) {
//            cout << "  Izbacujem jarbol " << j << endl;
            jarboli.erase(j);
        }
    }

//    cout << "-----------------------------" << endl;

    // Going from right to left <- <- <-
    jarboli.clear();
    map<int64_t,int64_t> najbliza_levo;
    for (int64_t i = n - 1; i >= 1; i--)
    {
        // Step 1 - dodaj jarbol u set

        int64_t pozicija = pozicije[i];
        int64_t visina = visine[i];
        jarboli[visina] = pozicija;
//        cout << "Ubacujem jarbol " << pozicija << endl;

        // Step 2 - odrediti sve tacke

        int64_t dx = pozicija - pozicije[i - 1];
        int64_t dy = visine[i - 1] - visina;

        int64_t duzina_prvog = (dx - abs(dy)) / 2;
        int64_t duzina_drugog = dx - duzina_prvog;

        // Fix bug...
        if (dy < 0) swap(duzina_prvog, duzina_drugog);

        int64_t tacka_preloma_x = pozicija - duzina_prvog;
        int64_t tacka_preloma_y = visina - duzina_prvog;

//        cout << "  Tacka preloma izmedju jarbola " << pozicija << " " << pozicije[i - 1];
//        cout << " je na poziciji " << tacka_preloma_x << " i visini " << tacka_preloma_y;
//        cout << endl;
        // Tacka preloma izmedju jarbola 1 6 je na poziciji 3 i visini 2
        // Tacka preloma izmedju jarbola 6 10 je na poziciji 7 i visini 4

        // Step 3 - koji jarboli se poklapaju sa nekom od dve duzi
        //          (y izmedju tacke preloma i najviseg od dva jarbola)

        int64_t min_y = tacka_preloma_y;
        int64_t max_y = max(visina, visine[i - 1]);

        // Trazim jarbole cija je visina >= tacka_preloma_y
        auto poklapanje = jarboli.lower_bound(tacka_preloma_y);

        set<int64_t> izbaceni_jarboli;

        while (poklapanje != jarboli.end() && poklapanje->first <= max_y) {
//            cout << "  Proveravam jarbol " << poklapanje->second << " visine " << poklapanje->first << endl;
            int64_t najbliza_x = pozicija - abs(visina - poklapanje->first);
            if (poklapanje->first <= visina && poklapanje->second != najbliza_x) {
                // Opadajuca duz
                najbliza_levo[poklapanje->second] = najbliza_x;
//                cout << "    1) Jarbol " << poklapanje->second << " ima tacku desno na " << najbliza_x << endl;
                izbaceni_jarboli.insert(poklapanje->first);
            }
            else if(visine[i-1] >= visina) {
                // Rastuca duz
                najbliza_x =  pozicije[i-1] + abs(visine[i-1] - poklapanje->first);
                najbliza_levo[poklapanje->second] = najbliza_x;
//                cout << "    2) Jarbol " << poklapanje->second << " ima tacku desno na " << najbliza_x << endl;
                izbaceni_jarboli.insert(poklapanje->first);
            }
            poklapanje++;
        }

        for (auto j : izbaceni_jarboli) {
//            cout << "  Izbacujem jarbol " << j << endl;
            jarboli.erase(j);
        }
    }

//    cout << "-----------------------------" << endl;
//
//    cout << "Desno : ";
    // for (int64_t j : pozicije) {
    //     int64_t min_distance = int64_t_MAX;
    //     if (najbliza_desno.count(j))
    //         min_distance = min(min_distance, abs(j - najbliza_desno[j]));
    //    cout << ((min_distance == int64_t_MAX) ? -1 : min_distance) << " ";
    // }
//    cout << endl;
//
//    cout << "Levo  : ";
    // for (int64_t j : pozicije) {
    //     int64_t min_distance = int64_t_MAX;
    //     if (najbliza_levo.count(j))
    //         min_distance = abs(j - najbliza_levo[j]);
    //    cout << ((min_distance == int64_t_MAX) ? -1 : min_distance) << " ";
    // }
//    cout << endl;

    for (int64_t j : pozicije) {
        int64_t min_distance = INT64_MAX;
        if (najbliza_levo.count(j))
            min_distance = abs(j - najbliza_levo[j]);
        if (najbliza_desno.count(j))
            min_distance = min(min_distance, abs(j - najbliza_desno[j]));
        cout << ((min_distance == INT64_MAX) ? -1 : min_distance) <<endl;
    }

}